/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.validacion.talon;

import ec.gob.sri.anexo.ats.validacion.util.OrigenValidacion;
import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import ec.gob.sri.dimm.ats.validacion.talon.GeneraTalonAtsDimm;
import ec.gob.sri.dimm.data.impl.ConexionBD;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TalonResumenATS {
    private static final String TALON_DIRECTORIO = "talon_resumen";
    private static final String TALON_LOGO_NAME = "sriTalonLogo.jpg";
    private static final String TALON_RESOURCES = "recursos";
    private static final String TALON_CSS = "talonAts.css";
    public static final int BUFFER_SIZE = 65536;
    private File xmlGenerado;

    public TalonResumenATS(File xmlFile) {
        this.xmlGenerado = xmlFile;
    }

    public File generarTalonCompletoDIMM() throws FileNotFoundException {
        FileInputStream anexoXmlInputStream = null;
        StringBuilder talonCompleto = new StringBuilder();
        String htmlResumenStr = "";
        File archivoHtml = null;
        PluginLogger.logInfo((String)"Generando Talon completo ATS", (String)"ec.gob.sri.dimm.ats.validacion");
        anexoXmlInputStream = new FileInputStream(this.xmlGenerado);
        GeneraTalonAtsDimm genTalDimm = new GeneraTalonAtsDimm(anexoXmlInputStream);
        htmlResumenStr = genTalDimm.generar(new ConexionBD().obtenerConexion(), OrigenValidacion.DIMM.name());
        talonCompleto.append(htmlResumenStr);
        String rutaDirectorio = Util.obtenerRutaBajoDimmHome((String)TALON_DIRECTORIO);
        this.verificarYguardarRecursos();
        archivoHtml = Util.guardarArchivo((String)rutaDirectorio, (String)"ATS_TalonResumen.html", (String)talonCompleto.toString());
        return archivoHtml;
    }

    private void verificarYguardarRecursos() {
        try {
            this.guardarRecurso(TALON_LOGO_NAME);
            this.guardarRecurso(TALON_CSS);
        }
        catch (IOException e) {
            PluginLogger.logError((String)"Ocurrio un problema al copiar uno de lo recursos", (String)"ec.gob.sri.dimm.ats.validacion", (Exception)e);
        }
    }

    private void guardarRecurso(String nombreRecurso) throws FileNotFoundException, IOException {
        String rutaDirectorio;
        File fResourceClone;
        InputStream recursoFile = TalonResumenATS.class.getResourceAsStream("/resources/" + nombreRecurso);
        if (!this.verificarRecurso(recursoFile, fResourceClone = new File(rutaDirectorio = Util.obtenerRutaBajoDimmHome((String)(TALON_DIRECTORIO + File.separator + TALON_RESOURCES)), nombreRecurso)).booleanValue()) {
            int len;
            recursoFile = TalonResumenATS.class.getResourceAsStream("/resources/" + nombreRecurso);
            FileOutputStream os = new FileOutputStream(fResourceClone);
            byte[] buf = new byte[1024];
            while ((len = recursoFile.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
        } else {
            PluginLogger.logInfo((String)("El recurso " + nombreRecurso + " no se actualizo"), (String)"ec.gob.sri.dimm.ats.validacion");
        }
    }

    public Boolean verificarRecurso(InputStream recurso, File destinoRecurso) throws IOException {
        boolean retorno;
        block12: {
            retorno = Boolean.FALSE;
            if (destinoRecurso.exists() && destinoRecurso.isFile()) {
                FileInputStream recursoDestFis = null;
                BufferedInputStream bufOrigenInput = null;
                BufferedInputStream bufDestinoInput = null;
                try {
                    int secondByte;
                    int firstByte;
                    recursoDestFis = new FileInputStream(destinoRecurso);
                    bufOrigenInput = new BufferedInputStream(recurso, 65536);
                    bufDestinoInput = new BufferedInputStream(recursoDestFis, 65536);
                    do {
                        if ((firstByte = bufOrigenInput.read()) == (secondByte = bufDestinoInput.read())) continue;
                        break block12;
                    } while (firstByte >= 0 || secondByte >= 0);
                    retorno = Boolean.TRUE;
                }
                finally {
                    try {
                        if (bufOrigenInput != null) {
                            bufDestinoInput.close();
                        }
                    }
                    finally {
                        if (bufOrigenInput != null) {
                            bufDestinoInput.close();
                        }
                    }
                }
            }
        }
        return retorno;
    }
}

